using System;
using System.Linq;

class Program
{
    static int N, M, K, L;
    static int[] A;
    static int maxBeauty = 0;

    static void Main()
    {
        int[] parameters = Console.ReadLine().Split().Select(int.Parse).ToArray();
        N = parameters[0];
        M = parameters[1];
        K = parameters[2];
        L = parameters[3];

        A = Console.ReadLine().Split().Select(int.Parse).ToArray();

        Permute(new int[N, M], 0);

        Console.WriteLine(maxBeauty);
    }

    static void Permute(int[,] matrix, int index)
    {
        if (index == A.Length)
        {
            CalculateBeauty(matrix);
            return;
        }

        for (int i = 0; i < N; i++)
        {
            for (int j = 0; j < M; j++)
            {
                if (matrix[i, j] == 0)
                {
                    matrix[i, j] = A[index];
                    Permute((int[,])matrix.Clone(), index + 1);
                    matrix[i, j] = 0;
                }
            }
        }
    }

    static void CalculateBeauty(int[,] matrix)
    {
        int currentBeauty = 0;

        for (int i = 0; i <= N - K; i++)
        {
            for (int j = 0; j <= M - L; j++)
            {
                int sum = 0;
                for (int ki = i; ki < i + K; ki++)
                {
                    for (int lj = j; lj < j + L; lj++)
                    {
                        sum += matrix[ki, lj];
                    }
                }
                currentBeauty += sum;
            }
        }

        if (currentBeauty > maxBeauty)
        {
            maxBeauty = currentBeauty;
        }
    }
}